/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	PuzzleInterface
**
** DESCRIPTION:	Interface for puzzle modules
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef PUZZLE_INTERFACE_H
#define PUZZLE_INTERFACE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
class CVillager;

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class IPuzzle
{
	//interface methods
	//setup
	public:		virtual void Reset() = 0;
	public:		virtual void LoadAssets() {};
	public:		virtual void ReleaseAssets() {};
	public:		virtual const int LoadState(const unsigned char *pData) = 0;
	public:		virtual const int SaveState(const unsigned char *pData, const int iMaxDataSize) const = 0;

	// process
	public:		virtual void Refresh() {};
	public:		virtual void Draw() const {};
	public:		virtual void Draw(const int iRef) const {};
	public:		virtual void Update() {};
	public:		virtual void Advance(CVillager &Villager, const int iRef = -1) {};
	public:		virtual void Complete() {};

	// access
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/